/*
 * Toolkit GUI, an application built for operating pinkRF's signal generators.
 *
 * Contact: https://www.pinkrf.com/contact/
 * Copyright © 2018-2024 pinkRF B.V
 * GNU General Public License version 3.
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program. If not, see https://www.gnu.org/licenses/
 *
 * Author: Iordan Svechtarov
 */

#include "gpioclassv2.h"
#include <QFile>
#include <QDebug>

using namespace std;

GPIOClass::GPIOClass(QString GPIO_BCM_number):gpionum(GPIO_BCM_number)
{
	//Instatiate GPIOClass object for GPIO pin number "gnum"
	export_GPIO();
}

GPIOClass::~GPIOClass()
{
	unexport_GPIO();
}

//
// TODO:
// - File closing?
// - combine gpionumber and direction?
// - pullup/pulldown configuration?
// - Handling in case exporting / unexporting fails?
//

bool GPIOClass::export_GPIO()
{
	QFile file("/sys/class/gpio/export");
	if (file.open(QIODevice::WriteOnly))
	{
		file.write(gpionum.toUtf8());
		return true;
	}

	qDebug() << file.errorString();
	return false;
}

bool GPIOClass::unexport_GPIO()
{
	QFile file("/sys/class/gpio/unexport");
	if (file.open(QIODevice::WriteOnly))
	{
		file.write(gpionum.toUtf8());
		return true;
	}

	qDebug() << file.errorString();
	return false;
}

bool GPIOClass::setDirection(QString direction)
{
	QFile file("/sys/class/gpio/gpio" + gpionum + "/direction");
	if (file.open(QIODevice::WriteOnly))
	{
		file.write(direction.toUtf8());
		return true;
	}

	qDebug() << file.errorString();
	return false;
}

int GPIOClass::readValue()
{
	QString readval = "";
	QFile file("/sys/class/gpio/gpio" + gpionum + "/value");
	if (file.open(QIODevice::ReadOnly))
	{
		readval = QString::fromUtf8(file.readAll());
		readval.replace("\n","");
		QRegExp numcheck("\\d+");

		if (numcheck.exactMatch(readval))
		{
			return readval.toInt();
		}
	}

	qDebug() << file.errorString();
	return -1;
}

bool GPIOClass::setValue(QString value)
{
	QFile file("/sys/class/gpio/gpio" + gpionum + "/value");
	if (file.open(QIODevice::WriteOnly))
	{
		file.write(value.toUtf8());
		return true;
	}

	qDebug() << file.errorString();
	return false;
}
